﻿// This adds cursor display capabilities
_this = this;
cursor_obj = {};
cursorTarget = (cursorTarget) ? cursorTarget : _this;
// When targeting scroll panes, target their mask_mc



// ______________________________________________________________________________
// PROGRAM

cursor_obj.getCursorImage = function()
{
	var output = null;
	
	// All possible cursor-change triggers
	
	// selection only
	if( _this.selectable  &&  !_this.editable)
		var output = "dropper_cursor";
	// selection + editable
	if( _this.selectable  &&  _this.editable  &&  Key.isDown(Key.SHIFT) )
		var output = "dropper_cursor";
	// selectable + editable + pencil
	if( _this.selectable  &&  _this.editable  &&  !Key.isDown(Key.SHIFT)  &&  _this.editMode=="pencil" )
		var output = "pencil_cursor";
	// selectable + editable + rectangle
	if( _this.selectable  &&  _this.editable  &&  !Key.isDown(Key.SHIFT)  &&  _this.editMode=="rectangle" )
		var output = "rectangle_cursor";
	// editable + pencil
	if( !_this.selectable  &&  _this.editable  &&  !Key.isDown(Key.SHIFT)  &&  _this.editMode=="pencil" )
		var output = "pencil_cursor";
	// editable + rectangle
	if( !_this.selectable  &&  _this.editable  &&  !Key.isDown(Key.SHIFT)  &&  _this.editMode=="rectangle" )
		var output = "rectangle_cursor";
	
	return output;
}// getCursorImage()



// ---------------------------------------
// PROGRAM MOUSE



// onMouseMove
_this.addEventListener( "onMouseMove", cursor_obj );
cursor_obj.onMouseMove = function()
{
	if(cursorTarget.hitTest(_root._xmouse, _root._ymouse, false) )
	{// over
		if(enabled  &&  visible  &&  selectable)
			cursor.image = cursor_obj.getCursorImage();
		cursor_obj.lastHit = true;
	}// over
	else
	{// outside
		if(cursor_obj.lastHit){
			cursor.image = null;
			cursor_obj.lastHit = false;
		}
	}// outside
}// onMouseMove()




// onKeyDown
_this.addEventListener( "keyDown", cursor_obj );
cursor_obj.keyDown = function()
{
	if( cursorTarget.hitTest(_root._xmouse, _root._ymouse, false) )
	{
		if(enabled  &&  visible  &&  selectable)
			cursor.image = cursor_obj.getCursorImage();
	}
}// onKeyDown()



// onKeyUp
_this.addEventListener( "keyUp", cursor_obj );
cursor_obj.keyUp = function()
{
	if( cursorTarget.hitTest(_root._xmouse, _root._ymouse, false) )
	{
		if(enabled  &&  visible  &&  selectable)
			cursor.image = cursor_obj.getCursorImage();
	}
}// onKeyUp()





// ______________________________________________________________________________
// UNLOAD
cursor_obj.unload = function()
{
	_this.removeEventListener( "onMouseMove", cursor_obj );
	_this.removeEventListener( "keyDown", cursor_obj );
	_this.removeEventListener( "keyUp", cursor_obj );
	//
	_this.removeEventListener( "unload", cursor_obj );
}// unload()
_this.addEventListener( "unload", cursor_obj );